/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fmaudio.customization.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.keksuccino.auudio.audio.AudioClip;
import de.keksuccino.fancymenu.api.item.CustomizationItem;
import de.keksuccino.fancymenu.api.item.CustomizationItemContainer;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fmaudio.audio.AudioHandler;
import de.keksuccino.fmaudio.customization.item.ACIHandler;
import de.keksuccino.fmaudio.customization.item.ACIMuteHandler;
import de.keksuccino.fmaudio.util.SoundSourceUtils;
import de.keksuccino.fmaudio.util.UrlUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AudioCustomizationItem
extends CustomizationItem {
    private static final ResourceLocation AUDIO_ELEMENT_TEXTURE = new ResourceLocation("fmaudio", "textures/audio_element.png");
    private static final Logger LOGGER = LogManager.getLogger((String)"fmaudio/AudioCustomizationItem");
    public List<MenuAudio> audios = new ArrayList<MenuAudio>();
    public SoundSource channel = SoundSource.MASTER;
    public boolean loop = true;
    public boolean oncePerSession = false;
    public boolean oncePerSessionCanStart = true;
    public volatile boolean isLoadingNextAudio = false;
    public volatile MenuAudio currentAudio = null;
    public volatile List<String> alreadyPlayed = new ArrayList<String>();
    public volatile MenuAudio audioToContinue = null;
    public float cachedMasterChannelVolume = -1.0f;
    public float cachedItemChannelVolume = -1.0f;
    protected Screen renderInScreen;
    protected volatile boolean tryKillNextAudioThread = false;
    public static volatile Map<String, AudioCustomizationItem> cachedItems = new HashMap<String, AudioCustomizationItem>();

    public AudioCustomizationItem(CustomizationItemContainer parentContainer, PropertiesSection item) {
        super(parentContainer, item);
        boolean isNewScreen;
        this.renderInScreen = Minecraft.m_91087_().f_91080_;
        boolean bl = isNewScreen = this.renderInScreen != ACIHandler.lastScreenGlobal;
        if (AudioCustomizationItem.isEditorActive()) {
            cachedItems.clear();
        }
        if (cachedItems.containsKey(this.actionId)) {
            AudioCustomizationItem old = cachedItems.get(this.actionId);
            this.audios = old.audios;
            this.channel = old.channel;
            this.loop = old.loop;
            this.oncePerSession = old.oncePerSession;
            this.currentAudio = old.currentAudio;
            this.alreadyPlayed = old.alreadyPlayed;
            this.audioToContinue = old.audioToContinue;
            this.cachedMasterChannelVolume = old.cachedMasterChannelVolume;
            this.cachedItemChannelVolume = old.cachedItemChannelVolume;
            if (old.oncePerSession && isNewScreen || !old.oncePerSessionCanStart) {
                this.oncePerSessionCanStart = false;
            }
            if (!this.oncePerSession && !this.loop && isNewScreen) {
                this.alreadyPlayed = new ArrayList<String>();
            }
        } else {
            String oncePerSessionString;
            block31: {
                String channelString = item.getEntryValue("channel");
                if (channelString != null) {
                    try {
                        SoundSource soundSource = SoundSourceUtils.getSourceForName(channelString);
                        if (soundSource != null) {
                            this.channel = soundSource;
                            break block31;
                        }
                        LOGGER.warn("WARNING: Channel was NULL after parsing! Channel set to MASTER! (" + channelString + ")");
                    }
                    catch (Exception e) {
                        LOGGER.warn("WARNING: Unable to parse channel! Channel set to MASTER! (" + channelString + ")");
                        e.printStackTrace();
                    }
                } else {
                    LOGGER.warn("WARNING: Channel is NULL! Channel set to MASTER!");
                }
            }
            String loopString = item.getEntryValue("loop");
            if (loopString != null && loopString.equalsIgnoreCase("false")) {
                this.loop = false;
            }
            if ((oncePerSessionString = item.getEntryValue("once_per_session")) != null && oncePerSessionString.equalsIgnoreCase("true")) {
                this.oncePerSession = true;
            }
            for (Map.Entry m : item.getEntries().entrySet()) {
                if (!((String)m.getKey()).startsWith("audio_source:")) continue;
                String audioIdentifier = ((String)m.getKey()).split(":", 2)[1];
                if (((String)m.getValue()).contains(";")) {
                    String[] audioProps = ((String)m.getValue()).split("[;]", -1);
                    if (audioProps.length >= 4) {
                        AudioClip.SoundType type;
                        String sourceString;
                        block32: {
                            sourceString = audioProps[0];
                            if (sourceString == null) {
                                LOGGER.error("ERROR: Source is NULL! (" + (String)m.getValue() + ")");
                                continue;
                            }
                            String typeString = audioProps[1];
                            if (typeString == null) {
                                LOGGER.error("ERROR: Type is NULL! (" + (String)m.getValue() + ")");
                                continue;
                            }
                            try {
                                type = AudioClip.SoundType.valueOf((String)typeString);
                                if (type == null) {
                                    LOGGER.error("ERROR: Sound type was NULL after parsing! (" + (String)m.getValue() + ")");
                                }
                                break block32;
                            }
                            catch (Exception e) {
                                LOGGER.error("ERROR: Unable to parse sound type! (" + (String)m.getValue() + ")");
                                e.printStackTrace();
                            }
                            continue;
                        }
                        String volString = audioProps[2];
                        int vol = 100;
                        if (MathUtils.isInteger((String)volString)) {
                            vol = Integer.parseInt(volString);
                        } else {
                            LOGGER.warn("WARNING: Unable to parse volume! Volume set to 100! (" + (String)m.getValue() + ")");
                        }
                        String indexString = audioProps[3];
                        int index = 0;
                        if (indexString != null && MathUtils.isInteger((String)indexString)) {
                            index = Integer.parseInt(indexString);
                            if (index < 0) {
                                index = 0;
                                LOGGER.warn("WARNING: Tried to use negative index! Index corrected to 0! (" + (String)m.getValue() + ")");
                            }
                        } else {
                            LOGGER.warn("WARNING: Unable to parse index! Index set to 0! (" + (String)m.getValue() + ")");
                        }
                        MenuAudio ma = new MenuAudio(sourceString, type, this);
                        ma.volume = vol;
                        if (audioIdentifier != null && audioIdentifier.length() >= 7) {
                            ma.audioIdentifier = audioIdentifier;
                        }
                        ma.index = index;
                        if (ACIHandler.currentLayoutAudios.contains(ma.path)) continue;
                        this.audios.add(ma);
                        ACIHandler.currentLayoutAudios.add(ma.path);
                        continue;
                    }
                    LOGGER.error("ERROR: Unable to parse audio source properties string! (" + (String)m.getValue() + ")");
                    continue;
                }
                LOGGER.error("ERROR: Invalid audio source properties string! (" + (String)m.getValue() + ")");
            }
        }
        if (this.oncePerSession) {
            this.loop = false;
        }
        if (this.oncePerSessionCanStart && !ACIMuteHandler.isMuted(this.actionId) && ACIHandler.playingAllowed() && !AudioCustomizationItem.isEditorActive() && (this.loop || this.alreadyPlayed.size() < this.audios.size() || !this.loop && this.currentAudio != null && this.currentAudio.isPlaying())) {
            for (MenuAudio m : this.audios) {
                if (!ACIHandler.lastPlayingAudioSources.contains(m.path)) continue;
                ACIHandler.lastPlayingAudioSources.remove(m.path);
                if (!ACIHandler.newLastPlayingAudioSources.contains(m.path)) {
                    ACIHandler.newLastPlayingAudioSources.add(m.path);
                }
                if (this.currentAudio != null && this.currentAudio.isPlaying()) break;
                this.audioToContinue = m;
                this.startAsynchronous(m, false);
                break;
            }
        }
        cachedItems.put(this.actionId, this);
        if (AudioCustomizationItem.isEditorActive()) {
            cachedItems.clear();
        }
    }

    public void render(PoseStack poseStack, Screen screen) {
        if (this.shouldRender()) {
            if (AudioCustomizationItem.isEditorActive()) {
                RenderSystem.m_69478_();
                RenderUtils.bindTexture((ResourceLocation)AUDIO_ELEMENT_TEXTURE);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                AudioCustomizationItem.m_93133_((PoseStack)poseStack, (int)this.getPosX(screen), (int)this.getPosY(screen), (float)1.0f, (float)1.0f, (int)this.width, (int)this.height, (int)this.width, (int)this.height);
            }
            this.tickAudio();
        }
    }

    public boolean shouldRender() {
        if (!AudioCustomizationItem.isEditorActive() && Minecraft.m_91087_().f_91080_ != this.renderInScreen) {
            return false;
        }
        return super.shouldRender();
    }

    public void tickAudio() {
        if (this.currentAudio != null && this.currentAudio.isPlaying() && this.alreadyPlayed.size() == 0 && !this.loop) {
            this.alreadyPlayed.add(this.currentAudio.audioIdentifier);
        }
        if ((ACIMuteHandler.isMuted(this.actionId) || !ACIHandler.playingAllowed()) && this.currentAudio != null) {
            this.currentAudio.getClip().stop();
            ACIHandler.lastPlayingAudioSources.remove(this.currentAudio.path);
            this.currentAudio = null;
        }
        if (!AudioCustomizationItem.isEditorActive() && !ACIMuteHandler.isMuted(this.actionId) && ACIHandler.playingAllowed() && this.oncePerSessionCanStart && !this.audios.isEmpty()) {
            MenuAudio nextAudio = null;
            if (this.currentAudio == null) {
                if (!this.isLoadingNextAudio) {
                    nextAudio = this.pickNextAudio();
                }
            } else if (!this.currentAudio.isPlaying()) {
                nextAudio = this.pickNextAudio();
            }
            if (nextAudio != null) {
                this.startAsynchronous(nextAudio, true);
            }
            float masterVol = Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER);
            float itemChannelVol = Minecraft.m_91087_().f_91066_.m_92147_(this.channel);
            if (this.cachedMasterChannelVolume != masterVol || this.cachedItemChannelVolume != itemChannelVol) {
                for (MenuAudio a : this.audios) {
                    a.setVolume(a.volume);
                }
            }
            this.cachedMasterChannelVolume = masterVol;
            this.cachedItemChannelVolume = itemChannelVol;
        }
    }

    protected MenuAudio pickNextAudio() {
        if (!this.audios.isEmpty()) {
            if (this.alreadyPlayed.size() >= this.audios.size()) {
                if (this.loop) {
                    this.alreadyPlayed.clear();
                } else {
                    return null;
                }
            }
            List<Object> nextAudios = new ArrayList();
            if (this.currentAudio != null) {
                nextAudios = this.getRemainingAudiosWithIndex(this.currentAudio.index);
                if (nextAudios.isEmpty()) {
                    int nextIndex = this.getNextAudioIndex();
                    if (nextIndex == -1) {
                        return null;
                    }
                    nextAudios = this.getRemainingAudiosWithIndex(nextIndex);
                }
            } else {
                int nextIndex = this.getNextAudioIndex();
                if (nextIndex == -1) {
                    return null;
                }
                nextAudios = this.getRemainingAudiosWithIndex(nextIndex);
            }
            if (!nextAudios.isEmpty()) {
                return (MenuAudio)nextAudios.get(MathUtils.getRandomNumberInRange((int)0, (int)(nextAudios.size() - 1)));
            }
        }
        return null;
    }

    protected void startAsynchronous(MenuAudio audio, boolean restart) {
        if (!(this.isLoadingNextAudio || this.currentAudio != null && this.currentAudio.isPlaying())) {
            if (this.currentAudio != null) {
                ACIHandler.lastPlayingAudioSources.remove(this.currentAudio.path);
            }
            this.isLoadingNextAudio = true;
            this.currentAudio = null;
            if (!this.alreadyPlayed.contains(audio.audioIdentifier)) {
                this.alreadyPlayed.add(audio.audioIdentifier);
            }
            if (audio.soundType == AudioClip.SoundType.EXTERNAL_LOCAL) {
                File f = new File(audio.path);
                if (!f.isFile() || !f.getPath().toLowerCase().endsWith(".ogg")) {
                    this.isLoadingNextAudio = false;
                    LOGGER.error("ERROR: Unable to start next audio! Invalid audio file! (" + audio.path + ")");
                    return;
                }
            } else if (audio.soundType == AudioClip.SoundType.EXTERNAL_WEB && !UrlUtils.isValidUrl(audio.path)) {
                this.isLoadingNextAudio = false;
                LOGGER.error("ERROR: Unable to start next audio! Invalid audio URL! (" + audio.path + ")");
                return;
            }
            new Thread(() -> {
                AudioClip clip = audio.getClip();
                if (clip != null) {
                    if (this.tryKillNextAudioThread) {
                        this.isLoadingNextAudio = false;
                        LOGGER.info("Force-killed audio loading thread, because element unloaded while thread was running! (" + audio.path + ")");
                        return;
                    }
                    audio.setVolume(audio.volume);
                    clip.setLooping(false);
                    if (restart) {
                        clip.stop();
                    }
                    clip.play();
                    long startTime = System.currentTimeMillis();
                    while (!clip.playing()) {
                        if (this.tryKillNextAudioThread) {
                            clip.stop();
                            this.isLoadingNextAudio = false;
                            LOGGER.info("Force-killed audio loading thread, because element unloaded while thread was running! (" + audio.path + ")");
                            return;
                        }
                        long now = System.currentTimeMillis();
                        if (startTime + 10000L > now) continue;
                        LOGGER.error("ERROR: Unable to start next audio! Timeout while starting clip! (" + audio.path + ")");
                        this.isLoadingNextAudio = false;
                        return;
                    }
                    if (!ACIHandler.lastPlayingAudioSources.contains(audio.path)) {
                        if (audio != this.audioToContinue) {
                            ACIHandler.lastPlayingAudioSources.add(audio.path);
                        } else {
                            this.audioToContinue = null;
                        }
                    }
                    this.currentAudio = audio;
                } else {
                    LOGGER.error("ERROR: Unable to start next audio! Clip is NULL! (" + audio.path + ")");
                }
                this.isLoadingNextAudio = false;
            }).start();
        }
    }

    protected List<MenuAudio> getRemainingAudiosWithIndex(int index) {
        ArrayList<MenuAudio> l = new ArrayList<MenuAudio>();
        for (MenuAudio a : this.audios) {
            if (this.alreadyPlayed.contains(a.audioIdentifier) || a.index != index) continue;
            l.add(a);
        }
        return l;
    }

    protected List<Integer> getSortedAudioIndexes() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (MenuAudio a : this.audios) {
            if (l.contains(a.index)) continue;
            l.add(a.index);
        }
        Collections.sort(l);
        return l;
    }

    protected int getNextAudioIndex() {
        List<Integer> indexes = this.getSortedAudioIndexes();
        if (!indexes.isEmpty()) {
            if (this.currentAudio == null) {
                return indexes.get(0);
            }
            for (int i : indexes) {
                if (i <= this.currentAudio.index) continue;
                return i;
            }
        }
        return -1;
    }

    public static class MenuAudio {
        public volatile String audioIdentifier = MenuCustomization.generateRandomActionId();
        public volatile int index = 0;
        public volatile String path;
        public volatile AudioClip.SoundType soundType;
        public volatile AudioClip clip = null;
        public volatile int volume = 100;
        public final AudioCustomizationItem parent;

        public MenuAudio(@Nonnull String source, @Nonnull AudioClip.SoundType soundType, @Nonnull AudioCustomizationItem parent) {
            this.path = source;
            this.soundType = soundType;
            this.parent = parent;
        }

        @Nullable
        public AudioClip getClip() {
            if (this.clip == null) {
                this.clip = AudioHandler.getAudio(this.path, this.soundType);
            }
            return this.clip;
        }

        public boolean isPlaying() {
            if (this.clip == null) {
                return false;
            }
            return this.clip.playing();
        }

        public void setVolume(int volume) {
            this.volume = volume;
            float newVolFloat = this.volume;
            if (this.parent.channel != SoundSource.MASTER) {
                float mcVol = Minecraft.m_91087_().f_91066_.m_92147_(this.parent.channel) * 100.0f;
                float clipVolOnePercent = (float)this.volume / 100.0f;
                newVolFloat = clipVolOnePercent * mcVol;
            }
            if (this.clip != null) {
                this.clip.setVolume((int)newVolFloat);
            }
        }
    }
}

